/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.endergetic.common.world.features;

import com.google.common.collect.ImmutableList;
import com.minecraftabnormals.endergetic.common.world.configs.CorrockArchConfig;
import com.minecraftabnormals.endergetic.common.world.configs.CorrockBranchConfig;
import com.minecraftabnormals.endergetic.common.world.configs.CorrockTowerConfig;
import com.minecraftabnormals.endergetic.common.world.configs.WeightedFeatureConfig;
import com.minecraftabnormals.endergetic.common.world.features.BolloomBudFeature;
import com.minecraftabnormals.endergetic.common.world.features.EndergeticEndGatewayFeature;
import com.minecraftabnormals.endergetic.common.world.features.PoiseBushFeature;
import com.minecraftabnormals.endergetic.common.world.features.PoiseClusterFeature;
import com.minecraftabnormals.endergetic.common.world.features.PoiseDomeFeature;
import com.minecraftabnormals.endergetic.common.world.features.PoiseTreeFeature;
import com.minecraftabnormals.endergetic.common.world.features.PuffBugHiveFeature;
import com.minecraftabnormals.endergetic.common.world.features.TallPoiseBushFeature;
import com.minecraftabnormals.endergetic.common.world.features.WeightedMultiFeature;
import com.minecraftabnormals.endergetic.common.world.features.corrock.CorrockArchFeature;
import com.minecraftabnormals.endergetic.common.world.features.corrock.CorrockBranchFeature;
import com.minecraftabnormals.endergetic.common.world.features.corrock.CorrockPatchFeature;
import com.minecraftabnormals.endergetic.common.world.features.corrock.CorrockShelfFeature;
import com.minecraftabnormals.endergetic.common.world.features.corrock.GroundPatchFeature;
import com.minecraftabnormals.endergetic.common.world.features.corrock.tower.LargeCorrockTowerFeature;
import com.minecraftabnormals.endergetic.common.world.features.corrock.tower.MediumCorrockTowerFeature;
import com.minecraftabnormals.endergetic.common.world.features.corrock.tower.SmallCorrockTowerFeature;
import com.minecraftabnormals.endergetic.common.world.placements.EEPlacements;
import com.minecraftabnormals.endergetic.common.world.placements.HeightmapSpreadLowerPlacement;
import com.minecraftabnormals.endergetic.common.world.placements.NoiseHeightmap32Placement;
import com.minecraftabnormals.endergetic.core.registry.EEBlocks;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.EndGatewayConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.SphereReplaceConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.NoiseDependant;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public final class EEFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"endergetic");
    public static final RegistryObject<Feature<NoFeatureConfig>> POISE_GRASS = EEFeatures.createFeature("poise_bush", () -> new PoiseBushFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Feature<NoFeatureConfig>> POISE_TALLGRASS = EEFeatures.createFeature("poise_tallgrass", () -> new TallPoiseBushFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Feature<NoFeatureConfig>> POISE_CLUSTER = EEFeatures.createFeature("poise_cluster", () -> new PoiseClusterFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Feature<NoFeatureConfig>> BOLLOOM_BUD = EEFeatures.createFeature("bolloom_bud", () -> new BolloomBudFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Feature<NoFeatureConfig>> PUFFBUG_HIVE = EEFeatures.createFeature("puffbug_hive", () -> new PuffBugHiveFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Feature<NoFeatureConfig>> POISE_DOME = EEFeatures.createFeature("poise_dome", () -> new PoiseDomeFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Feature<NoFeatureConfig>> POISE_TREE = EEFeatures.createFeature("poise_tree", () -> new PoiseTreeFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Feature<ProbabilityConfig>> CORROCK_PATCH = EEFeatures.createFeature("corrock_patch", () -> new CorrockPatchFeature((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_));
    public static final RegistryObject<Feature<SphereReplaceConfig>> GROUND_PATCH = EEFeatures.createFeature("ground_patch", () -> new GroundPatchFeature((Codec<SphereReplaceConfig>)SphereReplaceConfig.field_236516_a_));
    public static final RegistryObject<Feature<CorrockBranchConfig>> CORROCK_BRANCH = EEFeatures.createFeature("corrock_branch", () -> new CorrockBranchFeature(CorrockBranchConfig.CODEC));
    public static final RegistryObject<Feature<ProbabilityConfig>> SMALL_CORROCK_TOWER = EEFeatures.createFeature("small_corrock_tower", () -> new SmallCorrockTowerFeature((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_));
    public static final RegistryObject<Feature<CorrockTowerConfig>> MEDIUM_CORROCK_TOWER = EEFeatures.createFeature("medium_corrock_tower", () -> new MediumCorrockTowerFeature(CorrockTowerConfig.CODEC));
    public static final RegistryObject<Feature<CorrockTowerConfig>> LARGE_CORROCK_TOWER = EEFeatures.createFeature("large_corrock_tower", () -> new LargeCorrockTowerFeature(CorrockTowerConfig.CODEC));
    public static final RegistryObject<Feature<ProbabilityConfig>> CORROCK_SHELF = EEFeatures.createFeature("corrock_shelf", () -> new CorrockShelfFeature((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_));
    public static final RegistryObject<Feature<CorrockArchConfig>> CORROCK_ARCH = EEFeatures.createFeature("corrock_arch", () -> new CorrockArchFeature(CorrockArchConfig.CODEC));
    public static final RegistryObject<Feature<WeightedFeatureConfig>> WEIGHTED_FEATURES = EEFeatures.createFeature("weighted_features", () -> new WeightedMultiFeature(WeightedFeatureConfig.CODEC));
    public static final RegistryObject<Feature<EndGatewayConfig>> ENDERGETIC_GATEWAY = EEFeatures.createFeature("gateway", () -> new EndergeticEndGatewayFeature((Codec<EndGatewayConfig>)EndGatewayConfig.field_236522_a_));

    private static <F extends Feature<?>> RegistryObject<F> createFeature(String name, Supplier<F> feature) {
        return FEATURES.register(name, feature);
    }

    public static final class Configured {
        public static final ConfiguredFeature<?, ?> POISE_DOME = ((Feature)POISE_DOME.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(3, 0.02f, 1)));
        public static final ConfiguredFeature<?, ?> POISE_TREE = ((Feature)POISE_TREE.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.05f, 1)));
        public static final ConfiguredFeature<?, ?> POISE_CLUSTER = ((Feature)POISE_CLUSTER.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(((NoiseHeightmap32Placement)EEPlacements.NOISE_HEIGHTMAP_32.get()).func_227446_a_((IPlacementConfig)new NoiseDependant(-0.8, 4, 22)));
        public static final ConfiguredFeature<?, ?> PUFFBUG_HIVE = ((Feature)PUFFBUG_HIVE.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(((NoiseHeightmap32Placement)EEPlacements.NOISE_HEIGHTMAP_32.get()).func_227446_a_((IPlacementConfig)new NoiseDependant(-0.8, 9, 25)));
        public static final ConfiguredFeature<?, ?> BOLLOOM_BUD = ((Feature)BOLLOOM_BUD.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(((NoiseHeightmap32Placement)EEPlacements.NOISE_HEIGHTMAP_32.get()).func_227446_a_((IPlacementConfig)new NoiseDependant(-0.9, 90, 90)));
        public static final ConfiguredFeature<?, ?> POISE_GRASS = ((Feature)POISE_GRASS.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_243997_h).func_227228_a_(Placement.field_242900_d.func_227446_a_((IPlacementConfig)new NoiseDependant(-0.8, 5, 10)));
        public static final ConfiguredFeature<?, ?> TALL_POISE_GRASS = ((Feature)POISE_TALLGRASS.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(((NoiseHeightmap32Placement)EEPlacements.NOISE_HEIGHTMAP_32.get()).func_227446_a_((IPlacementConfig)new NoiseDependant(-0.8, 0, 7)));
        public static final ConfiguredFeature<?, ?> END_GATEWAY = ((Feature)ENDERGETIC_GATEWAY.get()).func_225566_b_((IFeatureConfig)EndGatewayConfig.func_214702_a((BlockPos)ServerWorld.field_241108_a_, (boolean)true)).func_227228_a_(Placement.field_215013_L.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e));
        public static final ConfiguredFeature<?, ?> END_GATEWAY_DELAYED = ((Feature)ENDERGETIC_GATEWAY.get()).func_225566_b_((IFeatureConfig)EndGatewayConfig.func_214698_a());
        public static final ConfiguredFeature<?, ?> CORROCK_PATCH = (ConfiguredFeature)((Feature)CORROCK_PATCH.get()).func_225566_b_((IFeatureConfig)new ProbabilityConfig(0.3f)).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(8);
        public static final ConfiguredFeature<?, ?> SPARSE_CORROCK_BRANCH = (ConfiguredFeature)((Feature)CORROCK_BRANCH.get()).func_225566_b_((IFeatureConfig)new CorrockBranchConfig((List<BlockState>)ImmutableList.of((Object)Blocks.field_150377_bs.func_176223_P(), (Object)((Block)EEBlocks.CORROCK_END_BLOCK.get()).func_176223_P()), 0.4f, 0.5f)).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(5);
        public static final ConfiguredFeature<?, ?> CORROCK_BRANCH = (ConfiguredFeature)((Feature)CORROCK_BRANCH.get()).func_225566_b_((IFeatureConfig)new CorrockBranchConfig((List<BlockState>)ImmutableList.of((Object)((Block)EEBlocks.CORROCK_END_BLOCK.get()).func_176223_P(), (Object)((Block)EEBlocks.EUMUS.get()).func_176223_P()), 0.5f, 0.6f)).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(64);
        public static final ConfiguredFeature<?, ?> SMALL_CORROCK_TOWER = (ConfiguredFeature)((Feature)SMALL_CORROCK_TOWER.get()).func_225566_b_((IFeatureConfig)new ProbabilityConfig(0.25f)).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(2);
        public static final ConfiguredFeature<?, ?> MEDIUM_CORROCK_TOWER = (ConfiguredFeature)((Feature)MEDIUM_CORROCK_TOWER.get()).func_225566_b_((IFeatureConfig)new CorrockTowerConfig(3, 4, 0.5f, 0.075f)).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(2);
        public static final ConfiguredFeature<?, ?> LARGE_CORROCK_TOWER = (ConfiguredFeature)((Feature)LARGE_CORROCK_TOWER.get()).func_225566_b_((IFeatureConfig)new CorrockTowerConfig(2, 5, 0.5f, 0.1f)).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(2);
        public static final ConfiguredFeature<?, ?> CORROCK_TOWER = (ConfiguredFeature)((Feature)WEIGHTED_FEATURES.get()).func_225566_b_((IFeatureConfig)WeightedFeatureConfig.createFromPairs(Pair.of(SMALL_CORROCK_TOWER, (Object)6), Pair.of(MEDIUM_CORROCK_TOWER, (Object)12), Pair.of(LARGE_CORROCK_TOWER, (Object)4))).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(256);
        public static final ConfiguredFeature<?, ?> CORROCK_SHELF = (ConfiguredFeature)((Feature)CORROCK_SHELF.get()).func_225566_b_((IFeatureConfig)new ProbabilityConfig(0.75f)).func_227228_a_((ConfiguredPlacement)((HeightmapSpreadLowerPlacement)EEPlacements.HEIGHTMAP_SPREAD_LOWER.get()).func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e).func_242728_a()).func_242731_b(6);
        public static final ConfiguredFeature<?, ?> CORROCK_ARCH = (ConfiguredFeature)((Feature)CORROCK_ARCH.get()).func_225566_b_((IFeatureConfig)new CorrockArchConfig(0.1f, 0.25f, 13.0f, 22.0f, 7.0f)).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(24);

        private static <FC extends IFeatureConfig> void register(String name, ConfiguredFeature<FC, ?> configuredFeature) {
            Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("endergetic", name), configuredFeature);
        }

        public static void registerConfiguredFeatures() {
            Configured.register("poise_dome", POISE_DOME);
            Configured.register("poise_tree", POISE_TREE);
            Configured.register("poise_cluster", POISE_CLUSTER);
            Configured.register("puffbug_hive", PUFFBUG_HIVE);
            Configured.register("bolloom_bud", BOLLOOM_BUD);
            Configured.register("poise_grass", POISE_GRASS);
            Configured.register("tall_poise_grass", TALL_POISE_GRASS);
            Configured.register("end_gateway", END_GATEWAY);
            Configured.register("end_gateway_delayed", END_GATEWAY_DELAYED);
            Configured.register("corrock_patch", CORROCK_PATCH);
            Configured.register("sparse_corrock_branch", SPARSE_CORROCK_BRANCH);
            Configured.register("corrock_branch", CORROCK_BRANCH);
            Configured.register("small_corrock_tower", SMALL_CORROCK_TOWER);
            Configured.register("medium_corrock_tower", MEDIUM_CORROCK_TOWER);
            Configured.register("large_corrock_tower", LARGE_CORROCK_TOWER);
            Configured.register("corrock_tower", CORROCK_TOWER);
            Configured.register("corrock_shelf", CORROCK_SHELF);
            Configured.register("corrock_arch", CORROCK_ARCH);
        }
    }
}

